<?php $__env->startSection('title', 'Book a Consultation - ' . $site->company_name); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-primary-50 min-h-screen py-16">
        <div class="container mx-auto px-4">
            <div class="max-w-2xl mx-auto bg-white rounded-2xl shadow-xl overflow-hidden">

                <div class="bg-primary-600 p-8 text-center text-white">
                    <h1 class="text-3xl font-bold">Schedule Your Session</h1>
                    <p class="mt-2 opacity-90">Choose your service and preferred time.</p>
                </div>

                <div class="p-8">
                    <form action="<?php echo e(route('booking.store')); ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
                        <?php echo csrf_field(); ?>

                        
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($services->isEmpty() || $consultants->isEmpty()): ?>
                            <div class="bg-red-50 p-4 rounded-lg text-red-700">
                                <p>Bookings are temporarily unavailable. Please check back later or call
                                    <?php echo e($site->contact_phone); ?>.</p>
                            </div>
                        <?php else: ?>
                            <div>
                                <label class="block text-gray-700 font-bold mb-2">Select Service</label>
                                <select name="service_id"
                                    class="w-full border-gray-300 rounded-lg shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-200 p-3 bg-gray-50">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($service->id); ?>"
                                            <?php echo e(isset($selectedService) && $selectedService->id == $service->id ? 'selected' : ''); ?>>
                                            <?php echo e($service->name); ?> (NPR <?php echo e(number_format($service->price, 0)); ?>)
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>

                            <div>
                                <label class="block text-gray-700 font-bold mb-2">Choose Consultant</label>
                                <select name="consultant_id" id="consultant_id"
                                    class="w-full border-gray-300 rounded-lg shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-200 p-3 bg-gray-50">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $consultants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $consultant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($consultant->id); ?>" <?php echo e(old('consultant_id') == $consultant->id ? 'selected' : ''); ?>>
                                            <?php echo e($consultant->user->name); ?> - <?php echo e($consultant->specialization); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-gray-700 font-bold mb-2">Preferred Date</label>
                                    <input type="date" name="booking_date" id="booking_date" required min="<?php echo e(date('Y-m-d')); ?>"
                                        value="<?php echo e(old('booking_date', date('Y-m-d'))); ?>"
                                        class="w-full border-gray-300 rounded-lg shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-200 p-3">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['booking_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                                <div>
                                    <label class="block text-gray-700 font-bold mb-2">Preferred Time</label>
                                    <select name="booking_time" id="booking_time" required
                                        class="w-full border-gray-300 rounded-lg shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-200 p-3 bg-white">
                                        <option value="">Loading available times...</option>
                                    </select>
                                    <p id="slot_help" class="text-xs text-gray-500 mt-1"></p>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['booking_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>

                            <div class="bg-gray-50 p-6 rounded-xl border border-gray-200">
                                <h3 class="font-bold text-gray-800 mb-4">Payment Required</h3>

                                <div class="flex flex-col md:flex-row gap-6 items-center mb-6">
                                    <div class="bg-white p-2 rounded shadow">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($site->payment_qr_image)): ?>
                                            <a href="<?php echo e(asset('storage/' . $site->payment_qr_image)); ?>" target="_blank">
                                                <img src="<?php echo e(asset('storage/' . $site->payment_qr_image)); ?>"
                                                    class="w-48 h-48 object-contain" alt="Payment QR">
                                            </a>
                                            <p class="mt-2 text-xs text-gray-400 text-center">
                                                Click the QR to open full size or download.
                                            </p>
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('storage/placeholder-image.jpg')); ?>"
                                                class="w-48 h-48 object-contain" alt="Payment QR">
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                    <div class="text-sm text-gray-600 space-y-1">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($site->payment_bank_name)): ?>
                                            <p><strong>Bank:</strong> <?php echo e($site->payment_bank_name); ?></p>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($site->payment_account_number)): ?>
                                            <p><strong>Acct:</strong> <?php echo e($site->payment_account_number); ?></p>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($site->payment_account_name)): ?>
                                            <p><strong>Name:</strong> <?php echo e($site->payment_account_name); ?></p>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($site->payment_instructions)): ?>
                                            <p class="mt-2 text-primary-600 font-bold">
                                                <?php echo nl2br(e($site->payment_instructions)); ?>

                                            </p>
                                        <?php else: ?>
                                            <p class="mt-2 text-primary-600 font-bold">
                                                Please upload the payment screenshot below.
                                            </p>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>

                                <label class="block text-gray-700 font-bold mb-2">Upload Payment Screenshot</label>
                                <input type="file" name="payment_proof" required accept="image/*"
                                    class="w-full border border-gray-300 rounded-lg p-2 bg-white">
                            </div>

                            <?php if (isset($component)) { $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf = $attributes; } ?>
<?php $component = App\View\Components\PrimaryButton::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('primary-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\PrimaryButton::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-full justify-center py-4 text-lg']); ?>
                                Confirm Booking Request
                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $attributes = $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $component = $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </form>
                </div>
            </div>

            <p class="text-center text-gray-500 mt-8 text-sm">
                Need help? Call us at <span class="font-bold"><?php echo e($site->contact_phone); ?></span>
            </p>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const consultantEl = document.getElementById('consultant_id');
            const dateEl = document.getElementById('booking_date');
            const timeEl = document.getElementById('booking_time');
            const helpEl = document.getElementById('slot_help');

            if (!consultantEl || !dateEl || !timeEl) return;

            const slotsUrl = "<?php echo e(route('booking.slots')); ?>";
            const oldTime = <?php echo json_encode(old('booking_time'), 15, 512) ?>;

            const setLoading = (text) => {
                timeEl.innerHTML = `<option value="">${text}</option>`;
                helpEl.textContent = '';
            };

            const loadSlots = async () => {
                const consultantId = consultantEl.value;
                const date = dateEl.value;

                if (!consultantId || !date) {
                    setLoading('Select date to see times');
                    return;
                }

                setLoading('Loading available times...');

                const url = new URL(slotsUrl, window.location.origin);
                url.searchParams.set('consultant_id', consultantId);
                url.searchParams.set('date', date);

                try {
                    const res = await fetch(url.toString(), { headers: { 'Accept': 'application/json' } });
                    if (!res.ok) throw new Error('Failed to load slots');
                    const data = await res.json();

                    const slots = Array.isArray(data.slots) ? data.slots : [];
                    if (slots.length === 0) {
                        timeEl.innerHTML = `<option value="">No slots available</option>`;
                        helpEl.textContent = 'Try another date or consultant.';
                        return;
                    }

                    const options = ['<option value="">Select a time</option>']
                        .concat(slots.map(t => `<option value="${t}">${t}</option>`))
                        .join('');
                    timeEl.innerHTML = options;

                    if (oldTime) {
                        timeEl.value = oldTime;
                    }
                    helpEl.textContent = `${slots.length} slots available.`;
                } catch (e) {
                    timeEl.innerHTML = `<option value="">Unable to load slots</option>`;
                    helpEl.textContent = 'Please refresh the page.';
                }
            };

            consultantEl.addEventListener('change', loadSlots);
            dateEl.addEventListener('change', loadSlots);

            loadSlots();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\code it\Laravel related\Vedic Platform by Gemeni\vedic-platform\resources\views/booking/create.blade.php ENDPATH**/ ?>