<?php $__env->startSection('title', 'Blog - ' . $site->company_name); ?>

<?php $__env->startSection('content'); ?>

    <header class="bg-primary-50 py-16 text-center">
        <div class="container mx-auto px-4">
            <h1 class="text-4xl font-extrabold text-gray-900 mb-4">Vedic Wisdom & Insights</h1>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                Explore articles on Astrology, Vastu Shastra, and Spiritual Rituals to guide your daily life.
            </p>
        </div>
    </header>

    <div class="container mx-auto px-4 py-12">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <article class="bg-white rounded-2xl shadow-sm hover:shadow-xl transition-shadow duration-300 overflow-hidden flex flex-col h-full border border-gray-100">

                <a href="<?php echo e(route('blog.show', $post->slug)); ?>" class="block overflow-hidden">
                    <img src="<?php echo e($post->image ? asset('storage/' . $post->image) : 'https://via.placeholder.com/600x300?text=Vedic+Article'); ?>"
                         class="w-full h-56 object-cover hover:scale-105 transition-transform duration-500">
                </a>

                <div class="p-6 flex flex-col flex-grow">
                    <div class="text-xs font-bold uppercase tracking-wider text-primary-600 mb-2">
                        <?php echo e($post->created_at->format('M d, Y')); ?> • <?php echo e($post->author->name); ?>

                    </div>

                    <a href="<?php echo e(route('blog.show', $post->slug)); ?>" class="hover:text-primary-600 transition duration-200">
                        <h2 class="text-xl font-bold text-gray-900 mb-3 line-clamp-2"><?php echo e($post->title); ?></h2>
                    </a>

                    <p class="text-gray-600 text-sm mb-6 flex-grow line-clamp-3">
                        <?php echo e(\Illuminate\Support\Str::limit(strip_tags($post->content), 120)); ?>

                    </p>

                    <a href="<?php echo e(route('blog.show', $post->slug)); ?>" class="inline-flex items-center text-primary-600 font-bold hover:text-primary-700 hover:underline mt-auto">
                        Read Article <span class="ml-1">&rarr;</span>
                    </a>
                </div>
            </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <div class="mt-12">
            <?php echo e($posts->links()); ?>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\code it\Laravel related\Vedic Platform by Gemeni\vedic-platform\resources\views/blog/index.blade.php ENDPATH**/ ?>