<?php $__env->startSection('title', 'Contact Us - ' . $site->company_name); ?>

<?php $__env->startSection('content'); ?>

    <header class="bg-primary-50 py-16 text-center">
        <div class="container mx-auto px-4">
            <h1 class="text-4xl font-extrabold text-gray-900 mb-4">Get in Touch</h1>
            <div class="w-24 h-1.5 bg-primary-500 mx-auto rounded-full"></div>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto mt-6">
                Have questions about a Puja, your Kundali, or Vastu? Our team is here to guide you.
            </p>
        </div>
    </header>

    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-16">

                <div class="space-y-12">
                    <div>
                        <h2 class="text-3xl font-bold text-gray-900 mb-8">Reach Out Directly</h2>
                        <div class="space-y-6">
                            <div class="flex items-start gap-4">
                                <div
                                    class="w-12 h-12 bg-primary-100 text-primary-600 rounded-xl flex items-center justify-center shrink-0">
                                    📞
                                </div>
                                <div>
                                    <h4 class="font-bold text-gray-900">Phone</h4>
                                    <p class="text-gray-600"><?php echo e($site->contact_phone ?? '+977-XXXXXXXXXX'); ?></p>
                                </div>
                            </div>

                            <div class="flex items-start gap-4">
                                <div
                                    class="w-12 h-12 bg-primary-100 text-primary-600 rounded-xl flex items-center justify-center shrink-0">
                                    ✉️
                                </div>
                                <div>
                                    <h4 class="font-bold text-gray-900">Email</h4>
                                    <p class="text-gray-600"><?php echo e($site->contact_email ?? 'info@vedicplatform.com'); ?></p>
                                </div>
                            </div>

                            <div class="flex items-start gap-4">
                                <div
                                    class="w-12 h-12 bg-primary-100 text-primary-600 rounded-xl flex items-center justify-center shrink-0">
                                    📍
                                </div>
                                <div>
                                    <h4 class="font-bold text-gray-900">Sanctum Office</h4>
                                    <p class="text-gray-600">Kathmandu, Nepal (Available for In-person Vastu Audit)</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="bg-primary-50 p-8 rounded-3xl border border-primary-100">
                        <h4 class="font-bold text-gray-900 mb-4">Follow Our Wisdom</h4>
                        <div class="flex gap-4">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($site->facebook_url)): ?>
                                <a href="<?php echo e($site->facebook_url); ?>"
                                    class="text-primary-600 font-bold hover:underline">Facebook</a>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($site->youtube_url)): ?>
                                <a href="<?php echo e($site->youtube_url); ?>"
                                    class="text-primary-600 font-bold hover:underline">YouTube</a>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-3xl shadow-2xl p-8 md:p-12 border border-gray-100 ">
                    <h2 class="text-3xl font-bold text-gray-900 mb-8 md:mb-12 text-center">Send Us a Message</h2>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
                        <div class="bg-green-100 text-green-700 p-4 rounded-xl mb-6 border border-green-200">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <form action="<?php echo e(route('contact.store')); ?>" method="POST" class="space-y-6">
                        <?php echo csrf_field(); ?>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-bold text-gray-700 mb-2">Your Name</label>
                                <input type="text" name="name" required
                                    class="w-full border-gray-200 rounded-xl p-3 focus:ring-primary-500 focus:border-primary-500"
                                    placeholder="Shree Ram">
                            </div>
                            <div>
                                <label class="block text-sm font-bold text-gray-700 mb-2">Email Address</label>
                                <input type="email" name="email" required
                                    class="w-full border-gray-200 rounded-xl p-3 focus:ring-primary-500 focus:border-primary-500"
                                    placeholder="ram@example.com">
                            </div>
                        </div>

                        <div>
                            <label class="block text-sm font-bold text-gray-700 mb-2">Subject</label>
                            <select name="subject"
                                class="w-full border-gray-200 rounded-xl p-3 focus:ring-primary-500 focus:border-primary-500 bg-white">
                                <option>General Inquiry</option>
                                <option>Vastu Consultation</option>
                                <option>Horoscope Clarification</option>
                                <option>Booking Issue</option>
                            </select>
                        </div>

                        <div>
                            <label class="block text-sm font-bold text-gray-700 mb-2">Your Message</label>
                            <textarea name="message" rows="5" required
                                class="w-full border-gray-200 rounded-xl p-3 focus:ring-primary-500 focus:border-primary-500"
                                placeholder="How can we assist you today?"></textarea>
                        </div>

                        <?php if (isset($component)) { $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf = $attributes; } ?>
<?php $component = App\View\Components\PrimaryButton::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('primary-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\PrimaryButton::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-full justify-center py-4 text-lg']); ?>
                            Send Message
                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $attributes = $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $component = $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
                    </form>
                </div>

            </div>
        </div>
    </section>

    <section class="py-20 bg-gray-50 border-t border-gray-100">
        <div class="container mx-auto px-4 text-center">
            <h3 class="text-2xl font-bold text-gray-900 mb-4">Frequently Asked Questions</h3>
            <p class="text-gray-500 mb-10">Quick answers to common spiritual inquiries.</p>

            <div class="max-w-3xl mx-auto space-y-4 text-left">
                <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100">
                    <h4 class="font-bold text-gray-900">How long does a consultation take?</h4>
                    <p class="text-gray-600 mt-2 text-sm">Most Vedic sessions last between 45 to 60 minutes, depending on
                        the complexity of your chart.</p>
                </div>
                <div class="bg-white p-6 rounded-2xl shadow-sm border border-gray-100">
                    <h4 class="font-bold text-gray-900">Is my birth time necessary?</h4>
                    <p class="text-gray-600 mt-2 text-sm">Yes, an accurate birth time is essential for precise Lagna Kundali
                        calculations.</p>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\code it\Laravel related\Vedic Platform by Gemeni\vedic-platform\resources\views/contact.blade.php ENDPATH**/ ?>