<?php $__env->startSection('title', $post->title . ' - ' . $site->company_name); ?>

<?php $__env->startSection('content'); ?>

    <nav class="border-b border-gray-100 py-4 bg-gray-50">
        <div class="container mx-auto px-4">
            <a href="<?php echo e(route('blog.index')); ?>" class="text-gray-500 hover:text-primary-600 flex items-center gap-2 font-medium transition-colors">
                &larr; Back to Articles
            </a>
        </div>
    </nav>

    <article class="max-w-3xl mx-auto px-4 py-12">
        <header class="mb-10 text-center">
            <span class="text-primary-600 font-bold tracking-wide uppercase text-xs bg-primary-50 px-3 py-1 rounded-full">
                Blog Post
            </span>
            <h1 class="text-3xl md:text-5xl font-extrabold mt-6 mb-6 leading-tight text-gray-900">
                <?php echo e($post->title); ?>

            </h1>

            <div class="flex items-center justify-center gap-4 text-gray-500 text-sm">
                <div class="flex items-center gap-2">
                    <div class="w-8 h-8 bg-gray-200 rounded-full flex items-center justify-center font-bold text-gray-600">
                        <?php echo e(substr($post->author->name, 0, 1)); ?>

                    </div>
                    <span class="font-medium text-gray-900"><?php echo e($post->author->name); ?></span>
                </div>
                <span class="text-gray-300">•</span>
                <time class="text-gray-500"><?php echo e($post->created_at->format('F j, Y')); ?></time>
            </div>
        </header>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($post->image): ?>
        <div class="mb-12 rounded-2xl overflow-hidden shadow-xl ring-1 ring-gray-900/5">
            <img src="<?php echo e(asset('storage/' . $post->image)); ?>" alt="<?php echo e($post->title); ?>" class="w-full h-auto object-cover">
        </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <div class="prose prose-lg prose-slate max-w-none mx-auto">
            <?php echo $post->content; ?>

        </div>

        <div class="mt-16 pt-10 border-t border-gray-100 text-center bg-gray-50 rounded-2xl p-8">
            <h3 class="font-bold text-2xl mb-3 text-gray-900">Enjoyed this article?</h3>
            <p class="text-gray-600 mb-8 max-w-md mx-auto">
                Book a consultation to discuss how this wisdom applies directly to your life chart.
            </p>

            <a href="<?php echo e(route('booking.create')); ?>">
                <?php if (isset($component)) { $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf = $attributes; } ?>
<?php $component = App\View\Components\PrimaryButton::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('primary-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\PrimaryButton::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'text-lg px-8 py-3']); ?>
                    Book a Consultation
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $attributes = $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $component = $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
            </a>
        </div>
    </article>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\code it\Laravel related\Vedic Platform by Gemeni\vedic-platform\resources\views/blog/show.blade.php ENDPATH**/ ?>