<?php $__env->startSection('title', 'Daily Horoscope - ' . $site->company_name); ?>

<?php $__env->startSection('content'); ?>

    <header class="bg-primary-50 py-16 text-center">
        <div class="container mx-auto px-4">
            <h1 class="text-4xl font-extrabold text-gray-900 mb-4">Daily Horoscope</h1>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                Select your zodiac sign to reveal what the stars have planned for you today.
            </p>
        </div>
    </header>

    <div class="container mx-auto py-16 px-4">
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            <?php
                $signs = [
                    ['slug' => 'aries', 'label' => 'Aries', 'icon' => '♈'],
                    ['slug' => 'taurus', 'label' => 'Taurus', 'icon' => '♉'],
                    ['slug' => 'gemini', 'label' => 'Gemini', 'icon' => '♊'],
                    ['slug' => 'cancer', 'label' => 'Cancer', 'icon' => '♋'],
                    ['slug' => 'leo', 'label' => 'Leo', 'icon' => '♌'],
                    ['slug' => 'virgo', 'label' => 'Virgo', 'icon' => '♍'],
                    ['slug' => 'libra', 'label' => 'Libra', 'icon' => '♎'],
                    ['slug' => 'scorpio', 'label' => 'Scorpio', 'icon' => '♏'],
                    ['slug' => 'sagittarius', 'label' => 'Sagittarius', 'icon' => '♐'],
                    ['slug' => 'capricorn', 'label' => 'Capricorn', 'icon' => '♑'],
                    ['slug' => 'aquarius', 'label' => 'Aquarius', 'icon' => '♒'],
                    ['slug' => 'pisces', 'label' => 'Pisces', 'icon' => '♓'],
                ];
            ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $signs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('horoscope.show', $sign['slug'])); ?>"
                    class="group bg-white p-8 rounded-2xl shadow-sm hover:shadow-xl transition-all duration-300 text-center border-t-4 border-primary-400 hover:-translate-y-1">
                    <div
                        class="w-16 h-16 bg-primary-50 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:bg-primary-600 transition-colors">
                        <span class="text-2xl text-primary-600 group-hover:text-white font-serif font-bold">
                            <?php echo e($sign['icon']); ?>

                        </span>
                    </div>

                    <h2 class="text-xl font-bold uppercase text-gray-800 group-hover:text-primary-600 transition-colors">
                        <?php echo e($sign['label']); ?>

                    </h2>

                    <p
                        class="text-sm text-gray-500 mt-3 font-medium group-hover:text-primary-500 flex items-center justify-center gap-1">
                        Check Prediction <span aria-hidden="true">&rarr;</span>
                    </p>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <div class="text-center mt-16">
            <a href="<?php echo e(route('services.index')); ?>"
                class="text-gray-500 hover:text-primary-600 font-medium transition-colors">
                Looking for a personal reading? <span class="underline">Book a Consultation</span>
            </a>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\code it\Laravel related\Vedic Platform by Gemeni\vedic-platform\resources\views/horoscope/index.blade.php ENDPATH**/ ?>