<?php $__env->startSection('title', 'Reschedule Booking - ' . $site->company_name); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-primary-50 min-h-screen py-16">
        <div class="container mx-auto px-4">
            <div class="max-w-2xl mx-auto bg-white rounded-2xl shadow-xl overflow-hidden">

                <div class="bg-primary-600 p-8 text-center text-white">
                    <h1 class="text-3xl font-bold">Reschedule Booking</h1>
                    <p class="mt-2 opacity-90">
                        <?php echo e($booking->service->name); ?> with <?php echo e($booking->consultant->user->name); ?>

                    </p>
                </div>

                <div class="p-8 space-y-6">
                    <div class="bg-gray-50 p-4 rounded-xl border border-gray-200 text-sm text-gray-700">
                        <p>
                            <span class="font-bold">Current:</span>
                            <?php echo e(\Carbon\Carbon::parse($booking->scheduled_at)->format('M d, Y h:i A')); ?>

                        </p>
                    </div>

                    <form action="<?php echo e(route('booking.reschedule.update', $booking)); ?>" method="POST" class="space-y-6">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-gray-700 font-bold mb-2">New Date</label>
                                <input type="date" name="booking_date" required min="<?php echo e(date('Y-m-d')); ?>"
                                    value="<?php echo e(old('booking_date', \Carbon\Carbon::parse($booking->scheduled_at)->format('Y-m-d'))); ?>"
                                    class="w-full border-gray-300 rounded-lg shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-200 p-3">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['booking_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            <div>
                                <label class="block text-gray-700 font-bold mb-2">New Time</label>
                                <input type="time" name="booking_time" required
                                    value="<?php echo e(old('booking_time', \Carbon\Carbon::parse($booking->scheduled_at)->format('H:i'))); ?>"
                                    class="w-full border-gray-300 rounded-lg shadow-sm focus:border-primary-500 focus:ring focus:ring-primary-200 p-3">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['booking_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="flex justify-end gap-4 items-center">
                            <a href="<?php echo e(route('dashboard')); ?>" class="px-6 py-3 text-gray-600 hover:text-gray-900 font-bold transition">
                                Back
                            </a>
                            <?php if (isset($component)) { $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf = $attributes; } ?>
<?php $component = App\View\Components\PrimaryButton::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('primary-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\PrimaryButton::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'px-8 py-3']); ?>
                                Save New Time
                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $attributes = $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $component = $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\code it\Laravel related\Vedic Platform by Gemeni\vedic-platform\resources\views/booking/reschedule.blade.php ENDPATH**/ ?>