<!DOCTYPE html>
<html>
<head>
    <style>
        .container { font-family: sans-serif; color: #333; max-width: 600px; margin: 0 auto; }
        .header { background-color: #ea580c; color: white; padding: 20px; text-align: center; border-radius: 8px 8px 0 0; }
        .content { padding: 30px; border: 1px solid #eee; border-top: none; line-height: 1.6; }
        .footer { text-align: center; font-size: 12px; color: #999; margin-top: 20px; }
        .label { font-weight: bold; color: #ea580c; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>New Message Received</h1>
        </div>
        <div class="content">
            <p>Hello Admin,</p>
            <p>You have received a new inquiry through the Vedic Platform contact form.</p>

            <hr style="border: none; border-top: 1px solid #eee; margin: 20px 0;">

            <p><span class="label">From:</span> <?php echo e($contactMessage->name); ?> (<?php echo e($contactMessage->email); ?>)</p>
            <p><span class="label">Subject:</span> <?php echo e($contactMessage->subject); ?></p>
            <p><span class="label">Message:</span></p>
            <p style="background-color: #fefce8; padding: 15px; border-radius: 8px; border-left: 4px solid #ea580c;">
                <?php echo e($contactMessage->message); ?>

            </p>

            <p style="margin-top: 30px; text-align: center;">
                <a href="<?php echo e(url('/admin/contact-messages/' . $contactMessage->id)); ?>"
                   style="background-color: #ea580c; color: white; padding: 12px 25px; text-decoration: none; border-radius: 5px; font-weight: bold;">
                   View in Admin Panel
                </a>
            </p>
        </div>
        <div class="footer">
            &copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.
        </div>
    </div>
</body>
</html>
<?php /**PATH D:\code it\Laravel related\Vedic Platform by Gemeni\vedic-platform\resources\views/emails/admin_contact_notification.blade.php ENDPATH**/ ?>