<?php $__env->startSection('title', 'My Dashboard - ' . $site->company_name); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-gray-50 min-h-screen py-12">
        <div class="container mx-auto px-4">

            <div class="mb-8 flex flex-col md:flex-row justify-between items-center bg-white p-6 rounded-2xl shadow-sm border border-gray-100">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Namaste, <?php echo e($user->name); ?>! 🙏</h1>
                    <p class="text-gray-500 text-sm mt-1">Manage your spiritual journey and upcoming consultations.</p>
                </div>
                <div class="mt-4 md:mt-0">
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="text-red-500 font-medium hover:text-red-700 hover:underline text-sm">
                            Log Out
                        </button>
                    </form>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">

                <div class="space-y-6">
                    <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100 text-center">
                        <div class="w-20 h-20 bg-primary-100 rounded-full flex items-center justify-center text-primary-600 text-2xl font-bold mx-auto mb-4">
                            <?php echo e(substr($user->name, 0, 1)); ?>

                        </div>
                        <h3 class="font-bold text-lg"><?php echo e($user->name); ?></h3>
                        <p class="text-gray-500 text-xs"><?php echo e($user->email); ?></p>

                        <div class="mt-4 pt-4 border-t border-gray-50 flex flex-col gap-2">
                            <a href="<?php echo e(route('profile.edit')); ?>"
                                class="w-full text-center text-primary-600 border border-primary-600 rounded-lg py-2 text-sm font-bold hover:bg-primary-50 transition">
                                Edit Profile
                            </a>
                        </div>

                        <div class="mt-4 pt-4 border-t border-gray-50 flex justify-center gap-4 text-sm">
                            <div class="text-center">
                                <span class="block font-bold text-gray-800"><?php echo e($bookings->count()); ?></span>
                                <span class="text-gray-400 text-xs">Bookings</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="lg:col-span-3">

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($user->astrologyProfile): ?>
                        <div class="bg-white p-6 rounded-xl shadow-sm border border-primary-100 text-center mb-8 relative overflow-hidden">
                            <div class="absolute top-0 left-0 w-full h-2 bg-gradient-to-r from-primary-400 to-red-500"></div>

                            <h3 class="font-bold text-gray-800 mb-4">Lagna Kundali</h3>

                            <div class="mx-auto w-full max-w-[350px] aspect-square relative bg-white p-1">

                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($chartData) && isset($chartData['Ascendant'])): ?>
                                    <?php
                                        $ascSign = $chartData['Ascendant']['current_sign'];

                                        function getSignForHouse($houseNum, $ascSign) {
                                            $s = ($ascSign + $houseNum - 1) % 12;
                                            return $s == 0 ? 12 : $s;
                                        }

                                        function getPlanetsInSign($signNum, $data) {
                                            $planets = [];
                                            $map = [
                                                'Sun' => 'Su', 'Moon' => 'Mo', 'Mars' => 'Ma', 'Mercury' => 'Me',
                                                'Jupiter' => 'Ju', 'Venus' => 'Ve', 'Saturn' => 'Sa', 'Rahu' => 'Ra', 'Ketu' => 'Ke',
                                            ];
                                            foreach ($data as $key => $planet) {
                                                if (in_array($key, ['Ascendant', 'Uranus', 'Neptune', 'Pluto'])) continue;
                                                if (isset($planet['current_sign']) && $planet['current_sign'] == $signNum) {
                                                    $planets[] = $map[$key] ?? substr($key, 0, 2);
                                                }
                                            }
                                            return implode(' ', $planets);
                                        }
                                    ?>

                                    <svg viewBox="0 0 400 400" xmlns="http://www.w3.org/2000/svg" class="w-full h-full">
                                        <defs>
                                            <style>
                                                /* Updated to match Primary Color (#ea580c) */
                                                .chart-line { stroke: #ea580c; stroke-width: 2; fill: none; }
                                                .planet-text { font-size: 14px; fill: #111827; font-weight: 700; font-family: sans-serif; }
                                                .sign-num { font-size: 14px; fill: #dc2626; font-weight: bold; opacity: 0.9; }
                                            </style>
                                        </defs>

                                        <rect x="2" y="2" width="396" height="396" class="chart-line" />
                                        <line x1="0" y1="0" x2="400" y2="400" class="chart-line" />
                                        <line x1="0" y1="400" x2="400" y2="0" class="chart-line" />
                                        <line x1="200" y1="0" x2="400" y2="200" class="chart-line" />
                                        <line x1="400" y1="200" x2="200" y2="400" class="chart-line" />
                                        <line x1="200" y1="400" x2="0" y2="200" class="chart-line" />
                                        <line x1="0" y1="200" x2="200" y2="0" class="chart-line" />

                                        <text x="200" y="185" text-anchor="middle" class="sign-num"><?php echo e($ascSign); ?></text>
                                        <text x="200" y="100" text-anchor="middle" class="planet-text"><?php echo e(getPlanetsInSign($ascSign, $chartData)); ?></text>
                                        <text x="200" y="70" text-anchor="middle" font-size="10" fill="red" font-weight="bold">Lagna</text>

                                        <?php $h2 = getSignForHouse(2, $ascSign); ?>
                                        <text x="100" y="25" text-anchor="middle" class="sign-num"><?php echo e($h2); ?></text>
                                        <text x="100" y="55" text-anchor="middle" class="planet-text"><?php echo e(getPlanetsInSign($h2, $chartData)); ?></text>

                                        <?php $h3 = getSignForHouse(3, $ascSign); ?>
                                        <text x="25" y="100" text-anchor="middle" class="sign-num"><?php echo e($h3); ?></text>
                                        <text x="60" y="100" text-anchor="middle" class="planet-text"><?php echo e(getPlanetsInSign($h3, $chartData)); ?></text>

                                        <?php $h4 = getSignForHouse(4, $ascSign); ?>
                                        <text x="180" y="205" text-anchor="middle" class="sign-num"><?php echo e($h4); ?></text>
                                        <text x="100" y="205" text-anchor="middle" class="planet-text"><?php echo e(getPlanetsInSign($h4, $chartData)); ?></text>

                                        <?php $h5 = getSignForHouse(5, $ascSign); ?>
                                        <text x="25" y="300" text-anchor="middle" class="sign-num"><?php echo e($h5); ?></text>
                                        <text x="60" y="300" text-anchor="middle" class="planet-text"><?php echo e(getPlanetsInSign($h5, $chartData)); ?></text>

                                        <?php $h6 = getSignForHouse(6, $ascSign); ?>
                                        <text x="100" y="385" text-anchor="middle" class="sign-num"><?php echo e($h6); ?></text>
                                        <text x="100" y="355" text-anchor="middle" class="planet-text"><?php echo e(getPlanetsInSign($h6, $chartData)); ?></text>

                                        <?php $h7 = getSignForHouse(7, $ascSign); ?>
                                        <text x="200" y="225" text-anchor="middle" class="sign-num"><?php echo e($h7); ?></text>
                                        <text x="200" y="300" text-anchor="middle" class="planet-text"><?php echo e(getPlanetsInSign($h7, $chartData)); ?></text>

                                        <?php $h8 = getSignForHouse(8, $ascSign); ?>
                                        <text x="300" y="385" text-anchor="middle" class="sign-num"><?php echo e($h8); ?></text>
                                        <text x="300" y="355" text-anchor="middle" class="planet-text"><?php echo e(getPlanetsInSign($h8, $chartData)); ?></text>

                                        <?php $h9 = getSignForHouse(9, $ascSign); ?>
                                        <text x="375" y="300" text-anchor="middle" class="sign-num"><?php echo e($h9); ?></text>
                                        <text x="340" y="300" text-anchor="middle" class="planet-text"><?php echo e(getPlanetsInSign($h9, $chartData)); ?></text>

                                        <?php $h10 = getSignForHouse(10, $ascSign); ?>
                                        <text x="220" y="205" text-anchor="middle" class="sign-num"><?php echo e($h10); ?></text>
                                        <text x="300" y="205" text-anchor="middle" class="planet-text"><?php echo e(getPlanetsInSign($h10, $chartData)); ?></text>

                                        <?php $h11 = getSignForHouse(11, $ascSign); ?>
                                        <text x="375" y="100" text-anchor="middle" class="sign-num"><?php echo e($h11); ?></text>
                                        <text x="340" y="100" text-anchor="middle" class="planet-text"><?php echo e(getPlanetsInSign($h11, $chartData)); ?></text>

                                        <?php $h12 = getSignForHouse(12, $ascSign); ?>
                                        <text x="300" y="25" text-anchor="middle" class="sign-num"><?php echo e($h12); ?></text>
                                        <text x="300" y="55" text-anchor="middle" class="planet-text"><?php echo e(getPlanetsInSign($h12, $chartData)); ?></text>
                                    </svg>
                                <?php else: ?>
                                    <div class="h-full flex items-center justify-center text-red-500 text-xs">
                                        Data unavailable. Update profile.
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <div class="text-left text-sm space-y-1 bg-primary-50 p-3 rounded-lg mt-4 border border-primary-100">
                                <p><span class="text-gray-500 w-12 inline-block">DOB:</span> <span class="font-medium text-gray-800"><?php echo e($user->astrologyProfile->dob); ?></span></p>
                                <p><span class="text-gray-500 w-12 inline-block">Time:</span> <span class="font-medium text-gray-800"><?php echo e(\Carbon\Carbon::parse($user->astrologyProfile->tob)->format('h:i A')); ?></span></p>
                                <p><span class="text-gray-500 w-12 inline-block">Place:</span> <span class="font-medium text-gray-800"><?php echo e($user->astrologyProfile->pob); ?></span></p>
                            </div>

                            <a href="<?php echo e(route('profile.edit')); ?>" class="block mt-4 text-xs font-bold text-primary-600 hover:underline">Edit Details</a>
                        </div>
                    <?php else: ?>
                        <div class="bg-primary-50 p-6 rounded-xl border border-dashed border-primary-300 text-center mb-8">
                            <h3 class="font-bold text-gray-800">Kundali Not Found</h3>
                            <p class="text-xs text-gray-500 mb-3">Please update your birth details to generate your Lagna China.</p>
                            <a href="<?php echo e(route('profile.edit')); ?>" class="inline-block bg-primary-600 text-white text-xs px-4 py-2 rounded-lg hover:bg-primary-700">Add Birth Details</a>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


                    <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center gap-2">
                        <svg class="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                        My Consultations
                    </h2>

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($bookings->isEmpty()): ?>
                        <div class="bg-white rounded-xl shadow-sm p-12 text-center border border-dashed border-gray-300">
                            <div class="text-gray-300 mb-4">
                                <svg class="w-16 h-16 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <h3 class="text-lg font-medium text-gray-900">No bookings found</h3>
                            <p class="text-gray-500 mb-6">You haven't scheduled any consultations yet.</p>

                            <a href="<?php echo e(route('services.index')); ?>">
                                <?php if (isset($component)) { $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf = $attributes; } ?>
<?php $component = App\View\Components\PrimaryButton::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('primary-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\PrimaryButton::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                    Book Your First Session
                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $attributes = $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $component = $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="space-y-4">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="bg-white rounded-xl shadow-sm p-6 border-l-4 <?php echo e($booking->status === 'confirmed' ? 'border-green-500' : ($booking->status === 'completed' ? 'border-gray-500' : 'border-primary-500')); ?> hover:shadow-md transition">
                                    <div class="flex flex-col md:flex-row justify-between md:items-center">

                                        <div class="mb-4 md:mb-0">
                                            <div class="flex items-center gap-2 mb-1">
                                                <span class="text-xs font-bold uppercase tracking-wider text-gray-400"><?php echo e($booking->service->category); ?></span>
                                                <span class="px-2 py-0.5 rounded text-xs font-semibold <?php echo e($booking->status === 'confirmed' ? 'bg-green-100 text-green-700' : 'bg-primary-100 text-primary-700'); ?>">
                                                    <?php echo e(ucfirst($booking->status)); ?>

                                                </span>
                                            </div>
                                            <h3 class="text-lg font-bold text-gray-800"><?php echo e($booking->service->name); ?></h3>
                                            <p class="text-sm text-gray-600">with <span class="font-semibold text-primary-600"><?php echo e($booking->consultant->user->name); ?></span></p>
                                        </div>

                                        <div class="text-right">
                                            <div class="text-gray-900 font-bold text-lg">
                                                <?php echo e(\Carbon\Carbon::parse($booking->scheduled_at)->format('M d, Y')); ?>

                                            </div>
                                            <div class="text-gray-500 text-sm mb-3">
                                                <?php echo e(\Carbon\Carbon::parse($booking->scheduled_at)->format('h:i A')); ?>

                                            </div>

                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($booking->meeting_link && $booking->status === 'confirmed'): ?>
                                                <a href="<?php echo e($booking->meeting_link); ?>" target="_blank"
                                                    class="inline-flex items-center gap-2 bg-green-600 text-white px-4 py-2 rounded-lg text-sm font-bold hover:bg-green-700 transition">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"></path></svg>
                                                    Join Meeting
                                                </a>
                                            <?php elseif($booking->status === 'pending'): ?>
                                                <div class="flex flex-col items-end gap-2">
                                                    <span class="text-xs text-primary-600 italic">Waiting for confirmation...</span>

                                                    <div class="flex gap-2">
                                                        <a href="<?php echo e(route('booking.reschedule.edit', $booking)); ?>"
                                                            class="inline-flex items-center gap-2 bg-white text-primary-700 border border-primary-200 px-3 py-2 rounded-lg text-xs font-bold hover:bg-primary-50 transition">
                                                            Reschedule
                                                        </a>

                                                        <form method="POST" action="<?php echo e(route('booking.cancel', $booking)); ?>"
                                                            onsubmit="return confirm('Cancel this booking request?');">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PATCH'); ?>
                                                            <button type="submit"
                                                                class="inline-flex items-center gap-2 bg-white text-red-600 border border-red-200 px-3 py-2 rounded-lg text-xs font-bold hover:bg-red-50 transition">
                                                                Cancel
                                                            </button>
                                                        </form>
                                                    </div>
                                                </div>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <div class="mt-8 bg-white p-6 rounded-xl shadow-sm border border-gray-100">
                        <h3 class="font-bold text-gray-800 mb-4">Share Your Experience</h3>

                        <form action="<?php echo e(route('testimonials.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Your Rating</label>
                                <select name="rating"
                                    class="w-full border-gray-300 rounded-md shadow-sm focus:border-primary-500 focus:ring-primary-500">
                                    <option value="5">⭐⭐⭐⭐⭐ (Excellent)</option>
                                    <option value="4">⭐⭐⭐⭐ (Very Good)</option>
                                    <option value="3">⭐⭐⭐ (Good)</option>
                                    <option value="2">⭐⭐ (Fair)</option>
                                    <option value="1">⭐ (Poor)</option>
                                </select>
                            </div>

                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Your Feedback</label>
                                <textarea name="message" rows="3"
                                    class="w-full border-gray-300 rounded-md shadow-sm focus:border-primary-500 focus:ring-primary-500"
                                    placeholder="How was your consultation?"></textarea>
                            </div>

                            <?php if (isset($component)) { $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf = $attributes; } ?>
<?php $component = App\View\Components\PrimaryButton::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('primary-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\PrimaryButton::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                Submit Review
                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $attributes = $__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__attributesOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf)): ?>
<?php $component = $__componentOriginal738438d805b9baf2d1402d7b79c4fcbf; ?>
<?php unset($__componentOriginal738438d805b9baf2d1402d7b79c4fcbf); ?>
<?php endif; ?>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\code it\Laravel related\Vedic Platform by Gemeni\vedic-platform\resources\views/dashboard/index.blade.php ENDPATH**/ ?>