@extends('layouts.frontend')

@section('title', 'Our Services - ' . $site->company_name)

@section('content')

    <div class="bg-primary-50 py-16 text-center">
        <div class="container mx-auto px-4">
            <h1 class="text-4xl font-extrabold text-gray-900 mb-4">Spiritual Services & Pujas</h1>
            <p class="text-gray-600 max-w-2xl mx-auto text-lg">
                Explore our comprehensive range of Vedic solutions, from detailed horoscope analysis to traditional rituals
                performed by expert priests.
            </p>
        </div>
    </div>

    <div class="container mx-auto px-4 py-16">

        @if ($services->isEmpty())
            <div class="text-center py-20 bg-gray-50 rounded-xl border border-dashed border-gray-300">
                <div class="text-6xl mb-4">🕉️</div>
                <h3 class="text-xl font-bold text-gray-800">No Services Available</h3>
                <p class="text-gray-500 mt-2">We are currently updating our catalog. Please check back later.</p>
            </div>
        @else
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                @foreach ($services as $service)
                    <div class="bg-white rounded-2xl shadow-sm hover:shadow-xl transition-shadow duration-300 border border-gray-100 overflow-hidden flex flex-col h-full">

                        <div class="relative h-56 overflow-hidden bg-gray-100">
                            <img src="{{ $service->image ? asset('storage/' . $service->image) : 'https://via.placeholder.com/400x250?text=' . urlencode($service->name) }}"
                                alt="{{ $service->name }}"
                                class="w-full h-full object-cover hover:scale-105 transition duration-500">

                            <div class="absolute top-4 right-4 bg-white/95 backdrop-blur-sm px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wider text-primary-600 shadow-sm">
                                {{ $service->category }}
                            </div>
                        </div>

                        <div class="p-8 flex-1 flex flex-col">
                            <h3 class="text-xl font-bold text-gray-900 mb-3">{{ $service->name }}</h3>

                            <div class="flex items-center gap-4 text-sm text-gray-500 mb-4">
                                <span class="flex items-center gap-1">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    {{ $service->duration_minutes }} mins
                                </span>
                                <span class="flex items-center gap-1 text-green-600 font-bold">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z">
                                        </path>
                                    </svg>
                                    NPR {{ number_format($service->price, 0) }}
                                </span>
                            </div>

                            <p class="text-gray-600 text-sm leading-relaxed mb-6 line-clamp-3 flex-1">
                                {{ strip_tags($service->description) }}
                            </p>

                            <a href="{{ route('booking.create', ['service_id' => $service->id]) }}"
                                class="w-full block text-center bg-gray-900 text-white font-bold py-3 rounded-xl hover:bg-primary-600 transition duration-300 shadow-lg hover:shadow-primary-200">
                                Book This {{ $service->category }} related service
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>

    <div class="bg-gray-900 text-white py-16 text-center">
        <div class="container mx-auto px-4">
            <h2 class="text-2xl font-bold mb-4">Need Guidance Choosing?</h2>
            <p class="text-gray-400 mb-8">Not sure which Puja or consultation is right for you? Talk to our support team.</p>
            <a href="tel:{{ $site->contact_phone }}"
                class="inline-flex items-center gap-2 border-2 border-white px-6 py-2 rounded-full hover:bg-white hover:text-gray-900 transition">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                    </path>
                </svg>
                Call {{ $site->contact_phone }}
            </a>
        </div>
    </div>

@endsection
