@extends('layouts.frontend')

@section('title', 'Edit Profile - ' . $site->company_name)

@section('content')
<div class="bg-primary-50 min-h-screen py-12">
    <div class="container mx-auto px-4 max-w-3xl">

        <h1 class="text-3xl font-bold text-gray-800 mb-8">Account Settings</h1>

        @if(session('success'))
            <div class="bg-green-100 text-green-700 p-4 rounded-lg mb-6 border border-green-200">
                {{ session('success') }}
            </div>
        @endif

        <div class="bg-white rounded-xl shadow-sm overflow-hidden">
            <form action="{{ route('profile.update') }}" method="POST" class="p-8 space-y-8">
                @csrf
                @method('PUT')

                <div>
                    <h2 class="text-xl font-bold text-gray-800 mb-4 border-b pb-2">Personal Information</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-gray-700 font-bold mb-2">Full Name</label>
                            <input type="text" name="name" value="{{ old('name', $user->name) }}"
                                   class="w-full border-gray-300 rounded-lg p-3 focus:ring-primary-500 focus:border-primary-500">
                            @error('name') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
                        </div>
                        <div>
                            <label class="block text-gray-700 font-bold mb-2">Email Address</label>
                            <input type="email" name="email" value="{{ old('email', $user->email) }}"
                                   class="w-full border-gray-300 rounded-lg p-3 focus:ring-primary-500 focus:border-primary-500">
                            @error('email') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
                        </div>
                    </div>
                </div>

                <div>
                    <h2 class="text-xl font-bold text-gray-800 mb-4 border-b pb-2 text-primary-600">Lagna China / Kundali Details</h2>
                    <p class="text-sm text-gray-500 mb-4">Update this to generate your birth chart.</p>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-gray-700 font-bold mb-2">Date of Birth</label>
                            <input type="date" name="dob"
                                   value="{{ old('dob', optional($user->astrologyProfile)->dob) }}"
                                   class="w-full border-gray-300 rounded-lg p-3 focus:ring-primary-500 focus:border-primary-500">
                        </div>

                        <div>
                            <label class="block text-gray-700 font-bold mb-2">Time of Birth</label>
                            <input type="time" name="tob"
                                   value="{{ old('tob', optional($user->astrologyProfile)->tob) }}"
                                   class="w-full border-gray-300 rounded-lg p-3 focus:ring-primary-500 focus:border-primary-500">
                        </div>

                        <div>
                            <label class="block text-gray-700 font-bold mb-2">Place of Birth</label>
                            <input type="text" name="pob" placeholder="e.g. Kathmandu"
                                   value="{{ old('pob', optional($user->astrologyProfile)->pob) }}"
                                   class="w-full border-gray-300 rounded-lg p-3 focus:ring-primary-500 focus:border-primary-500">
                        </div>

                        <div>
                            <label class="block text-gray-700 font-bold mb-2">Gender</label>
                            <select name="gender" class="w-full border-gray-300 rounded-lg p-3 bg-white focus:ring-primary-500 focus:border-primary-500">
                                <option value="male" {{ (optional($user->astrologyProfile)->gender == 'male') ? 'selected' : '' }}>Male</option>
                                <option value="female" {{ (optional($user->astrologyProfile)->gender == 'female') ? 'selected' : '' }}>Female</option>
                                <option value="other" {{ (optional($user->astrologyProfile)->gender == 'other') ? 'selected' : '' }}>Other</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="bg-primary-50 p-6 rounded-lg border border-primary-100">
                    <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center gap-2">
                        <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path></svg>
                        Change Password
                    </h2>
                    <p class="text-sm text-gray-500 mb-4">Leave blank if you don't want to change it.</p>

                    <div class="space-y-4">
                        <div>
                            <label class="block text-gray-700 text-sm font-bold mb-1">Current Password</label>
                            <input type="password" name="current_password" class="w-full border-gray-300 rounded-lg p-3 focus:ring-primary-500 focus:border-primary-500">
                            @error('current_password') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-1">New Password</label>
                                <input type="password" name="new_password" class="w-full border-gray-300 rounded-lg p-3 focus:ring-primary-500 focus:border-primary-500">
                                @error('new_password') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
                            </div>
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-1">Confirm New Password</label>
                                <input type="password" name="new_password_confirmation" class="w-full border-gray-300 rounded-lg p-3 focus:ring-primary-500 focus:border-primary-500">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="flex justify-end gap-4 items-center">
                    <a href="{{ route('dashboard') }}" class="px-6 py-3 text-gray-600 hover:text-gray-900 font-bold transition">Cancel</a>

                    <x-primary-button class="px-8 py-3">
                        Save Changes
                    </x-primary-button>
                </div>

            </form>
        </div>
    </div>
</div>
@endsection
