@extends('layouts.frontend')

@section('title', ucfirst($sign) . ' Horoscope - ' . $site->company_name)

@section('content')

    <div class="bg-primary-50 min-h-screen flex items-center justify-center py-16 px-4">

        <div class="max-w-2xl w-full bg-white rounded-2xl shadow-2xl overflow-hidden transform transition-all">

            <div class="bg-primary-600 p-10 text-center text-white relative overflow-hidden">
                <div class="absolute top-0 right-0 -mr-10 -mt-10 w-40 h-40 bg-white opacity-10 rounded-full"></div>

                <h1 class="text-5xl font-extrabold uppercase tracking-widest">{{ $sign }}</h1>
                <p class="mt-2 text-primary-100 font-medium text-lg">
                    {{ \Carbon\Carbon::now()->format('l, F j, Y') }}
                </p>
            </div>

            <div class="p-8 space-y-8">
                <div>
                    <h2 class="text-2xl font-bold text-gray-800 mb-4 pb-2 border-b border-gray-100 flex items-center gap-2">
                        <span>✨</span> Daily Prediction
                    </h2>

                    @if($daily)
                        <p class="text-gray-700 leading-relaxed text-lg">{{ $daily->prediction }}</p>

                        <div class="mt-6 flex flex-wrap gap-4 text-sm font-bold">
                            <span class="bg-green-100 text-green-700 px-4 py-2 rounded-full border border-green-200 shadow-sm">
                                🍀 Lucky #: {{ $daily->lucky_number }}
                            </span>
                            <span class="bg-blue-100 text-blue-700 px-4 py-2 rounded-full border border-blue-200 shadow-sm">
                                🎨 Color: {{ $daily->lucky_color }}
                            </span>
                        </div>

                        {{-- New detailed sections --}}
                        <div class="mt-8 grid gap-4">
                            @if($daily->love)
                                <div class="bg-pink-50 p-4 rounded-lg text-sm">
                                    <h3 class="font-bold text-pink-700 mb-1">❤️ Love</h3>
                                    <p class="text-pink-900">{{ $daily->love }}</p>
                                </div>
                            @endif

                            @if($daily->career)
                                <div class="bg-blue-50 p-4 rounded-lg text-sm">
                                    <h3 class="font-bold text-blue-700 mb-1">💼 Career</h3>
                                    <p class="text-blue-900">{{ $daily->career }}</p>
                                </div>
                            @endif

                            @if($daily->finance)
                                <div class="bg-emerald-50 p-4 rounded-lg text-sm">
                                    <h3 class="font-bold text-emerald-700 mb-1">💰 Finance</h3>
                                    <p class="text-emerald-900">{{ $daily->finance }}</p>
                                </div>
                            @endif

                            @if($daily->health)
                                <div class="bg-amber-50 p-4 rounded-lg text-sm">
                                    <h3 class="font-bold text-amber-700 mb-1">🩺 Health</h3>
                                    <p class="text-amber-900">{{ $daily->health }}</p>
                                </div>
                            @endif
                        </div>
                    @else
                        <div class="bg-gray-50 p-6 rounded-xl border border-dashed border-gray-300 text-center">
                            <p class="text-gray-400 italic">The stars are silent today. Please check back later.</p>
                        </div>
                    @endif
                </div>

                @if($monthly)
                <div class="bg-primary-50 p-6 rounded-xl border border-primary-100">
                    <h3 class="text-lg font-bold text-gray-800 mb-2 flex items-center gap-2">
                        <span>📅</span> Monthly Overview
                    </h3>
                    <p class="text-gray-600 text-sm leading-relaxed">{{ $monthly->prediction }}</p>
                </div>
                @endif
            </div>

            <div class="bg-gray-50 p-5 text-center border-t border-gray-100">
                <a href="{{ route('horoscope.index') }}" class="text-primary-600 font-bold hover:text-primary-700 transition flex items-center justify-center gap-2">
                    &larr; Check Another Sign
                </a>
            </div>
        </div>
    </div>

@endsection
