@extends('layouts.frontend')

@section('title', $post->title . ' - ' . $site->company_name)

@section('content')

    <nav class="border-b border-gray-100 py-4 bg-gray-50">
        <div class="container mx-auto px-4">
            <a href="{{ route('blog.index') }}" class="text-gray-500 hover:text-primary-600 flex items-center gap-2 font-medium transition-colors">
                &larr; Back to Articles
            </a>
        </div>
    </nav>

    <article class="max-w-3xl mx-auto px-4 py-12">
        <header class="mb-10 text-center">
            <span class="text-primary-600 font-bold tracking-wide uppercase text-xs bg-primary-50 px-3 py-1 rounded-full">
                Blog Post
            </span>
            <h1 class="text-3xl md:text-5xl font-extrabold mt-6 mb-6 leading-tight text-gray-900">
                {{ $post->title }}
            </h1>

            <div class="flex items-center justify-center gap-4 text-gray-500 text-sm">
                <div class="flex items-center gap-2">
                    <div class="w-8 h-8 bg-gray-200 rounded-full flex items-center justify-center font-bold text-gray-600">
                        {{ substr($post->author->name, 0, 1) }}
                    </div>
                    <span class="font-medium text-gray-900">{{ $post->author->name }}</span>
                </div>
                <span class="text-gray-300">•</span>
                <time class="text-gray-500">{{ $post->created_at->format('F j, Y') }}</time>
            </div>
        </header>

        @if($post->image)
        <div class="mb-12 rounded-2xl overflow-hidden shadow-xl ring-1 ring-gray-900/5">
            <img src="{{ asset('storage/' . $post->image) }}" alt="{{ $post->title }}" class="w-full h-auto object-cover">
        </div>
        @endif

        <div class="prose prose-lg prose-slate max-w-none mx-auto">
            {!! $post->content !!}
        </div>

        <div class="mt-16 pt-10 border-t border-gray-100 text-center bg-gray-50 rounded-2xl p-8">
            <h3 class="font-bold text-2xl mb-3 text-gray-900">Enjoyed this article?</h3>
            <p class="text-gray-600 mb-8 max-w-md mx-auto">
                Book a consultation to discuss how this wisdom applies directly to your life chart.
            </p>

            <a href="{{ route('booking.create') }}">
                <x-primary-button class="text-lg px-8 py-3">
                    Book a Consultation
                </x-primary-button>
            </a>
        </div>
    </article>

@endsection
