@extends('layouts.frontend')

@section('title', 'Our Story & Philosophy - ' . $site->company_name)

@section('content')

<header class="bg-primary-50 py-24 text-center relative overflow-hidden">
    <div class="container mx-auto px-4 relative z-10">
        <span class="text-primary-600 font-bold uppercase tracking-widest text-sm bg-white px-4 py-1.5 rounded-full shadow-sm">Our Lineage</span>
        <h1 class="text-4xl md:text-6xl font-extrabold text-gray-900 mt-8 mb-6 leading-tight">
            Bridging Ancient Wisdom <br>
            <span class="text-primary-600">with Modern Clarity</span>
        </h1>
        <p class="text-xl text-gray-600 max-w-3xl mx-auto leading-relaxed">
            Since our founding, {{ $site->company_name }} has been dedicated to preserving the purity of Vedic sciences while making them accessible for the modern seeker.
        </p>
    </div>
    <div class="absolute -bottom-12 -right-12 w-64 h-64 bg-primary-200 rounded-full opacity-20 blur-3xl"></div>
</header>

<section class="py-24 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-20 items-center">
            <div class="relative">
                <div class="aspect-square bg-primary-100 rounded-3xl overflow-hidden shadow-2xl rotate-3 transition-transform hover:rotate-0 duration-500">
                    <img src="https://via.placeholder.com/800x800?text=Vedic+Wisdom" alt="Our Philosophy" class="w-full h-full object-cover">
                </div>
                <div class="absolute -bottom-6 -right-6 bg-white p-4 rounded-2xl shadow-xl max-w-xs border border-primary-50">
                    <p class="text-primary-600 font-bold text-3xl">10+</p>
                    <p class="text-gray-500 text-sm font-medium">Years of guiding souls through the stars.</p>
                </div>
            </div>

            <div class="space-y-20">
                <h2 class="text-3xl md:text-4xl font-extrabold text-gray-900">Why We Exist</h2>
                <p class="text-gray-600 leading-relaxed text-lg">
                    In a world filled with uncertainty, the ancient Vedas offer a roadmap for living in harmony with the cosmos. We believe that astrology is not about "fortune telling," but about understanding the energetic patterns of your life to make better choices.
                </p>

                <div class="grid grid-cols-1 sm:grid-cols-2 gap-8">
                    <div class="space-y-3">
                        <div class="w-10 h-10 bg-primary-100 text-primary-600 rounded-lg flex items-center justify-center font-bold">01</div>
                        <h4 class="font-bold text-gray-900">Authentic Lineage</h4>
                        <p class="text-sm text-gray-500">Our experts come from traditional Gurukuls with decades of ritual experience.</p>
                    </div>
                    <div class="space-y-3">
                        <div class="w-10 h-10 bg-primary-100 text-primary-600 rounded-lg flex items-center justify-center font-bold">02</div>
                        <h4 class="font-bold text-gray-900">Scientific Approach</h4>
                        <p class="text-sm text-gray-500">We use precise astronomical data to calculate your Lagna Kundali and planetary transits.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="py-24 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl font-bold text-gray-900 mb-4">The Pillars of Our Platform</h2>
            <div class="w-20 h-1.5 bg-primary-500 mx-auto rounded-full"></div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-12">
            <div class="bg-white p-10 rounded-3xl shadow-sm border border-gray-100 hover:-translate-y-2 transition-transform">
                <div class="text-4xl mb-6">🪐</div>
                <h3 class="text-xl font-bold text-gray-900 mb-4">Precision Astrology</h3>
                <p class="text-gray-500 leading-relaxed">
                    Detailed birth chart analysis using Vedic principles to provide clarity on career, relationships, and health.
                </p>
            </div>

            <div class="bg-white p-10 rounded-3xl shadow-sm border border-gray-100 hover:-translate-y-2 transition-transform">
                <div class="text-4xl mb-6">🏠</div>
                <h3 class="text-xl font-bold text-gray-900 mb-4">Vastu Harmony</h3>
                <p class="text-gray-500 leading-relaxed">
                    Designing and balancing your living spaces to align with natural laws, ensuring prosperity and peace.
                </p>
            </div>

            <div class="bg-white p-10 rounded-3xl shadow-sm border border-gray-100 hover:-translate-y-2 transition-transform">
                <div class="text-4xl mb-6">🔥</div>
                <h3 class="text-xl font-bold text-gray-900 mb-4">Sacred Rituals</h3>
                <p class="text-gray-500 leading-relaxed">
                    Authentic Pujas and Path services performed by verified priests to remove obstacles and invite blessings.
                </p>
            </div>
        </div>
    </div>
</section>

<section class="py-20 bg-primary-600 text-center text-white relative overflow-hidden">
    <div class="container mx-auto px-4 relative z-10">
        <h2 class="text-3xl md:text-5xl font-bold mb-8">Ready to Start Your Journey?</h2>
        <p class="text-primary-100 mb-10 text-lg max-w-xl mx-auto">
            Schedule a session with one of our masters today and find the clarity you've been seeking.
        </p>
        <div class="flex flex-col sm:flex-row justify-center gap-6">
            <a href="{{ route('services.index') }}" class="bg-white text-primary-600 px-10 py-4 rounded-full font-extrabold text-lg hover:bg-primary-50 transition shadow-xl">
                View Services
            </a>
            <a href="{{ route('contact') }}" class="border-2 border-white text-white px-10 py-4 rounded-full font-extrabold text-lg hover:bg-white/10 transition">
                Contact Us
            </a>
        </div>
    </div>
</section>

@endsection
