<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Event;
use Illuminate\Auth\Events\Registered;
use App\Models\CompanySetting;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Schema;
use App\Models\NavigationItem; // Import this
use App\Models\Booking;
use App\Observers\BookingObserver;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void

    {
        // This grants "Super Admin" everything regardless of policies
        Gate::before(function ($user, $ability) {
            return $user->hasRole('super_admin') ? true : null;
        });
        Event::listen(Registered::class, function ($event) {
            // Automatically give new signups a 'client' role
            // Make sure you create the 'client' role in the Admin Panel first!
            $event->user->assignRole('client');
        });
        // Check if table exists to avoid errors during initial migration
        if (Schema::hasTable('company_settings')) {
            // Get the first row, or create an empty one if none exists
            $settings = CompanySetting::firstOrNew();

            // Share variable '$site' with ALL blade views
            View::share('site', $settings);
        }
        // 2. Dynamic Navigation (Add this block)
        if (Schema::hasTable('navigation_items')) {
            $menuItems = NavigationItem::where('is_active', true)
                ->whereNull('parent_id') // Get top-level items only
                ->with('children')       // Eager load submenus (for dropdowns)
                ->orderBy('order')
                ->get();

            View::share('menuItems', $menuItems);
        }

        Booking::observe(BookingObserver::class);
    }
}
