<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    /** @use HasFactory<\Database\Factories\ServiceFactory> */
    use HasFactory;
    // This property tells Laravel: "It is okay to save data to these columns"
    protected $fillable = [
        'name',
        'slug',
        'category',
        'description',
        'price',
        'image',
        'is_active',
        'duration_minutes'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'price' => 'decimal:2',
    ];
    public function bookings()
    {
        return $this->hasMany(Booking::class);
    }
}
