<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AstrologyProfile extends Model
{
    /** @use HasFactory<\Database\Factories\AstrologyProfileFactory> */
    use HasFactory;
    protected $fillable = [
        'user_id',
        'full_name',
        'dob',
        'tob',
        'pob',
        'chart_data',
        'latitude',
        'longitude',
        'timezone',
        'gender'
    ];
    // Automatically convert JSON from DB to PHP Array
    protected $casts = [
        'chart_data' => 'array',
    ];
    public function user()
    {
        return $this->belongsTo(User::class);
    }

}
