<?php

namespace App\Mail;

use App\Models\Booking;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class AdminBookingUpdatedMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public function __construct(public Booking $booking, public string $reason)
    {
    }

    public function envelope(): Envelope
    {
        $subject = match ($this->reason) {
            'status' => 'Booking Status Updated - ' . $this->booking->service->name,
            'scheduled_at' => 'Booking Rescheduled - ' . $this->booking->service->name,
            'meeting_link' => 'Meeting Link Updated - ' . $this->booking->service->name,
            default => 'Booking Updated - ' . $this->booking->service->name,
        };

        return new Envelope(subject: $subject);
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.admin_booking_update',
        );
    }
}

