<?php

namespace App\Http\Controllers;

use App\Models\Horoscope;
use App\Http\Requests\StoreHoroscopeRequest;
use App\Http\Requests\UpdateHoroscopeRequest;
use Illuminate\Http\Request;
use Carbon\Carbon;

class HoroscopeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // Show a page with all 12 zodiac signs
        return view('horoscope.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreHoroscopeRequest $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    // public function show(Horoscope $horoscope)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     */
    public function show($sign)
    {
        // 1. Get Today's Date
        $today = Carbon::today();

        // 2. Find Daily Prediction
        $daily = Horoscope::where('zodiac_sign', $sign)
            ->where('type', 'daily')
            ->whereDate('valid_from', '<=', $today)
            ->whereDate('valid_to', '>=', $today)
            ->first();

        // 3. Find Monthly Prediction
        $monthly = Horoscope::where('zodiac_sign', $sign)
            ->where('type', 'monthly')
            ->whereMonth('valid_from', $today->month)
            ->whereYear('valid_from', $today->year)
            ->first();

        return view('horoscope.show', compact('sign', 'daily', 'monthly'));
    }
    public function edit(Horoscope $horoscope)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateHoroscopeRequest $request, Horoscope $horoscope)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Horoscope $horoscope)
    {
        //
    }
}
