<?php

namespace App\Http\Controllers;

use App\Models\Service;
use App\Models\Consultant; // Import the Consultant Model
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        // 1. Fetch Active Services (Showing top 3 looks better on home)
        $services = Service::where('is_active', true)->take(3)->get();

        // 2. Fetch Active Consultants (with their User details)
        $consultants = Consultant::with('user')
            ->where('is_available', true)
            ->take(4) // Limit to 4 for a nice grid
            ->get();

        // 3. NEW: Fetch Featured Testimonials
        $testimonials = \App\Models\Testimonial::with('user')
            ->where('is_active', true)
            ->where('is_featured', true)
            ->latest()
            ->take(3)
            ->get();

        return view('welcome', compact('services', 'consultants', 'testimonials'));
    }
}
