<?php

// namespace App\Http\Controllers;

// use Illuminate\Http\Request;
// use Illuminate\Support\Facades\Auth;
// use App\Services\AstrologyService; // Import Service

// class UserDashboardController extends Controller
// {
//     public function index()
//     {
//         // 1. Get the currently logged-in user
//         $user = Auth::user();

//         // 2. Fetch their bookings (newest first) with Service & Consultant details
//         $bookings = $user->bookings()
//             ->with(['service', 'consultant.user']) // Eager load to avoid N+1 problem
//             ->latest()
//             ->get();
//         // Default Chart Data (Empty)
//         $chartData = null;

//         // 3. If user has a profile, Calculate/Fetch Real Data
//         if ($user->astrologyProfile) {
//             $astroService = new AstrologyService();
//             // If user has a profile, Calculate/Fetch Real Data
//             if ($user->astrologyProfile) {
//                 $chartData = $astroService->getChartData(
//                     $user->astrologyProfile->dob,
//                     $user->astrologyProfile->tob,
//                     $user->astrologyProfile->pob
//                 );
//             }
//         }

//         return view('dashboard.index', compact('user', 'bookings', 'chartData'));
//     }
// }



namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Services\AstrologyService;

class DashboardController extends Controller
{
   public function index(AstrologyService $astroService)
{
    $user = Auth::user();
    $bookings = $user->bookings()->with(['service', 'consultant.user'])->latest()->get();

    $chartData = null;

    if ($user->astrologyProfile) {
        $profile = $user->astrologyProfile;

        // 1. CHECK DATABASE FIRST
        if (!empty($profile->chart_data)) {
            // Data exists! Use it without hitting API.
            $chartData = $profile->chart_data;
        }
        // 2. IF EMPTY, HIT API
        else {
            $apiData = $astroService->getChartData(
                $profile->dob,
                $profile->tob,
                $profile->pob
            );

            if ($apiData) {
                // 3. SAVE TO DATABASE FOR NEXT TIME
                $profile->update(['chart_data' => $apiData]);
                $chartData = $apiData;
            }
        }
    }

    return view('dashboard.index', compact('user', 'bookings', 'chartData'));
}
}
