<?php

namespace App\Http\Controllers;

use App\Models\Post;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    // Page 1: List all articles
    public function index()
    {
        $posts = Post::where('status', 'published')
                     ->latest()
                     ->paginate(9);

        return view('blog.index', compact('posts'));
    }

    // Page 2: Read a single article
    public function show($slug)
    {
        $post = Post::where('slug', $slug)
                    ->where('status', 'published')
                    ->firstOrFail();

        return view('blog.show', compact('post'));
    }
}
