<?php

// namespace App\Filament\Widgets;

// use App\Models\Booking;
// use App\Models\User;
// use Filament\Widgets\StatsOverviewWidget as BaseWidget;
// use Filament\Widgets\StatsOverviewWidget\Stat;

// class StatsOverview extends BaseWidget
// {
//     protected function getStats(): array
//     {
//         return [
//             Stat::make('Total Bookings', Booking::count())
//                 ->description('All time appointments')
//                 ->descriptionIcon('heroicon-m-calendar')
//                 ->color('primary'),

//             Stat::make('Pending Requests', Booking::where('status', 'pending')->count())
//                 ->description('Requires attention')
//                 ->descriptionIcon('heroicon-m-clock')
//                 ->color('warning'),

//             Stat::make('Total Users', User::count())
//                 ->description('Registered clients')
//                 ->descriptionIcon('heroicon-m-users')
//                 ->color('success'),
//         ];
//     }
// }



namespace App\Filament\Widgets;

use App\Models\Booking;
use App\Models\User;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Illuminate\Support\Facades\Auth;

class StatsOverview extends BaseWidget
{
    protected function getStats(): array
    {
        $user = Auth::user();

        // 1. Start a Query for Bookings
        $bookingQuery = Booking::query();

        // 2. If it is a Consultant, filter ONLY their bookings
        if ($user->hasRole('panel_user') && $user->consultant) {
            $bookingQuery->where('consultant_id', $user->consultant->id);
        }

        // 3. Prepare the Stats
        $stats = [
            Stat::make('Total Bookings', $bookingQuery->count())
                ->description('All time appointments')
                ->descriptionIcon('heroicon-m-calendar')
                ->color('primary'),

            Stat::make('Pending Requests', (clone $bookingQuery)->where('status', 'pending')->count())
                ->description('Requires attention')
                ->descriptionIcon('heroicon-m-clock')
                ->color('warning'),
        ];

        // 4. SECURITY: Only show "Total Users" to Super Admin
        // Consultants should NOT see how many users the whole platform has.
        if ($user->hasRole('super_admin')) {
            $stats[] = Stat::make('Total Users', User::count())
                ->description('Registered clients')
                ->descriptionIcon('heroicon-m-users')
                ->color('success');
        }

        return $stats;
    }
}
