<?php

namespace App\Filament\Resources;

use App\Filament\Resources\CompanySettingResource\Pages;
use App\Filament\Resources\CompanySettingResource\RelationManagers;
use App\Models\CompanySetting;
use Filament\Forms;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class CompanySettingResource extends Resource
{
    protected static ?string $model = CompanySetting::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    public static function shouldRegisterNavigation(): bool
{
    return auth()->user()->hasRole('super_admin');
}

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make('General Info')
                    ->schema([
                        TextInput::make('company_name')->required(),
                        FileUpload::make('logo')
                            ->image()
                            ->directory('branding') // Save in storage/branding
                            ->visibility('public'),
                    ])->columns(2),

                Section::make('Contact Details')
                    ->schema([
                        TextInput::make('contact_email')->email(),
                        TextInput::make('contact_phone')->tel(),
                        Textarea::make('address')->rows(3),
                    ])->columns(2),

                Section::make('Social Media')
                    ->schema([
                        TextInput::make('facebook_url')->prefix('https://'),
                        TextInput::make('instagram_url')->prefix('https://'),
                        TextInput::make('youtube_url')->prefix('https://'),
                    ])->columns(3),

                Section::make('Payment Details')
                    ->schema([
                        TextInput::make('payment_bank_name')
                            ->label('Bank Name'),
                        TextInput::make('payment_account_number')
                            ->label('Account Number'),
                        TextInput::make('payment_account_name')
                            ->label('Account Name'),
                        FileUpload::make('payment_qr_image')
                            ->label('Payment QR Image')
                            ->image()
                            ->directory('payment')
                            ->visibility('public'),
                        Textarea::make('payment_instructions')
                            ->label('Payment Instructions')
                            ->rows(3)
                            ->columnSpanFull(),
                    ])
                    ->columns(2),

                    Section::make('Private policy and terms of service')
                        ->schema([
                            RichEditor::make('privacy_policy')
                                ->columnSpanFull(),
                            RichEditor::make('terms_of_service')
                                ->columnSpanFull(),
                        ])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('company_name')
                    ->searchable(),
                Tables\Columns\ImageColumn::make('logo')
                    ->searchable(),
                Tables\Columns\TextColumn::make('contact_email')
                    ->searchable(),
                Tables\Columns\TextColumn::make('contact_phone')
                    ->searchable(),
                Tables\Columns\TextColumn::make('facebook_url')
                    ->searchable(),
                Tables\Columns\TextColumn::make('instagram_url')
                    ->searchable(),
                Tables\Columns\TextColumn::make('youtube_url')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCompanySettings::route('/'),
            'create' => Pages\CreateCompanySetting::route('/create'),
            'edit' => Pages\EditCompanySetting::route('/{record}/edit'),
        ];
    }
}
