<?php

namespace App\Filament\Resources;

use App\Filament\Resources\AstrologyProfileResource\Pages;
use App\Models\AstrologyProfile;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class AstrologyProfileResource extends Resource
{
    protected static ?string $model = AstrologyProfile::class;
    protected static ?string $navigationIcon = 'heroicon-o-moon'; // Moon icon for astrology
    protected static ?string $navigationGroup = 'User Data';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make('Birth Details')
                    ->description('Required information for accurate Kundali generation')
                    ->schema([
                        Forms\Components\Select::make('user_id')
                            ->relationship('user', 'name')
                            ->preload()
                            ->searchable()
                            ->required(),

                        Forms\Components\TextInput::make('full_name')
                            ->required(),

                        Forms\Components\Select::make('gender')
                            ->options([
                                'male' => 'Male',
                                'female' => 'Female',
                                'other' => 'Other',
                            ])->required(),

                        Forms\Components\DatePicker::make('dob')
                            ->label('Date of Birth')
                            ->native(false)
                            ->required(),

                        Forms\Components\TimePicker::make('tob')
                            ->label('Time of Birth')
                            ->native(false)
                            ->required(),

                        Forms\Components\TextInput::make('pob')
                            ->label('Place of Birth')
                            ->placeholder('City, Country')
                            ->required(),
                    ])->columns(2),

                Forms\Components\Section::make('Geographic Coordinates')
                    ->description('Used for high-precision planetary calculations')
                    ->schema([
                        Forms\Components\TextInput::make('latitude')
                            ->numeric()
                            ->placeholder('e.g., 27.7172'),
                        Forms\Components\TextInput::make('longitude')
                            ->numeric()
                            ->placeholder('e.g., 85.3240'),
                        Forms\Components\TextInput::make('timezone')
                            ->default('Asia/Kathmandu'),
                    ])->columns(3),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('full_name')->searchable(),
                Tables\Columns\TextColumn::make('user.name')->label('Account'),
                Tables\Columns\TextColumn::make('dob')->label('DOB')->date(),
                Tables\Columns\TextColumn::make('pob')->label('Birth Place'),
                Tables\Columns\TextColumn::make('timezone'),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAstrologyProfiles::route('/'),
            'create' => Pages\CreateAstrologyProfile::route('/create'),
            'edit' => Pages\EditAstrologyProfile::route('/{record}/edit'),
        ];
    }
}
